
/**
 ******************************************************************************
 *
 * @file        MG32_BLDC_System.h
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/28
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _MG32_BLDC_SYSTEM_H_
#define _MG32_BLDC_SYSTEM_H_


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_DRV.h"
#include "MG32_ChipInit.h"
#include "MG32_LCM_API.h"
#include "MG32_ADC_API.h"
#include "MG32_BLDC_API.h"
#include <stdio.h>

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/** 
 * @enum		Motor_StateDef
 * @brief		declare Motor current state 
 */        
typedef enum {
    Motor_IDLE,
    Motor_Starup,
	Motor_Running,
    Motor_Stuck,
    Motor_Stop,
    Motor_Hall_Fault,
    Motor_OverCurrent,
    Motor_ReverseRotating,
} Motor_StateDef;

/** 
 * @enum		Motor_TableStateDef
 * @brief		declare calculate sinewave table state 
 */        
typedef enum {
    Table_IDLE,
    Table_Calculate,
    Table_Calculate_End,
} Motor_TableStateDef;

/** 
 * @enum		Motor_HandlerDef
 * @brief		declare Motor control parameters 
 */        
typedef struct __attribute__((packed)) {
    uint16_t                SineWaveTable_IDX;      // There are two SineWaveTable that needs to indicated
    
    int32_t                 DesiredDuty;            // Specifies the ADC sample result (Convert Duty cycle)
    
    int32_t                 CurrentDuty;            // Specifies the motor current duty cycle
    
    uint32_t                MotorSpeed;             // Specifies the speed of motor.
    
    Motor_StateDef          MotorState;             // Specifies the motor state. Please reference Motor_StateDef enum.
    
    Motor_TableStateDef     TableState;             // Specifies the state for calculation SineWaveTable.
                                                    // Please reference Motor_TableStateDef enum.
    
    uint16_t                commutate_flag;         // Specifies the commutate event.
    
    uint32_t                commutate_time;         // Specifies the commutate time.
    
    uint16_t                Direction;              // Specifies the motor direction. Please reference Motor_Direction define.
    
    uint16_t                MinSpeed_flag;          // Specifies the flag of motor speed. Please reference Motor_LowSpeed_Flag.
    
    uint16_t                MaxSpeed_flag;          // Specifies the flag of motor speed. Please reference Motor_LowSpeed_Flag.
    
    uint16_t                HallUsedPattern;        // Specifies the Hall pattern. It should be 0x003F.
    
} Motor_HandlerDef;

/* Private define ------------------------------------------------------------*/
//!@{
//! defgroup Motor_Direction Motor direction (Forward or Reverse)
#define MOTOR_FORWARD   1
#define MOTOR_REVERSE	0
//!@}

//!@{
//! defgroup Motor_LowSpeed_Flag Motor speed lower than MIN_RPM
#define MOTOR_LOWER_MIN_RPM     1
#define MOTOR_HIGHER_MIN_RPM	0
#define MOTOR_LOWER_MAX_RPM     1
#define MOTOR_HIGHER_MAX_RPM	0
//!@}

//!@{
//! defgroup Motor_Key_Function
#define START_BUTTON        PA1
#define STOP_BUTTON	        PA2
#define DIRECTION_BUTTON	PA3
//!@}

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

#endif
